float3 iInstancedPosition( float3 pm, float4 mtx0, float4 mtx1, float4 mtx2 ) 
{ 
	float4x4 world = {float4(mtx0.x, mtx1.x, mtx2.x, 0), 
		float4(mtx0.y, mtx1.y, mtx2.y, 0), 
		float4(mtx0.z, mtx1.z, mtx2.z, 0), 
		float4(mtx0.w, mtx1.w, mtx2.w, 1)}; 
	// For instancing, transform the input position.
	float4 HPm = float4(pm, 1.0f);
	HPm = mul(HPm, world);
	return HPm.xyz; 
} 

float3 iInstancedNormalWM( float3 nm, float4 m0, float4 m1, float4 m2) 
{ 
	// Compute the adjoint matrix of incoming matrix. 
	float3 row0 = float3(m0.x,m1.x,m2.x);
	float3 row1 = float3(m0.y,m1.y,m2.y);
	float3 row2 = float3(m0.z,m1.z,m2.z);
	float3x3 m = float3x3(row0, row1, row2); 
	float3 v = float3(m[1].y*m[2].z - m[1].z*m[2].y, m[0].z*m[2].y - m[0].y*m[2].z, m[0].y*m[1].z - m[0].z*m[1].y); 
	float3x3 adjMtx = float3x3(v,
		float3(m[1].z*m[2].x - m[1].x*m[2].z, m[0].x*m[2].z - m[0].z*m[2].x, m[0].z*m[1].x - m[0].x*m[1].z), 
		float3(m[1].x*m[2].y - m[1].y*m[2].x, m[0].y*m[2].x - m[0].x*m[2].y, m[0].x*m[1].y - m[0].y*m[1].x)); 
	return normalize(mul(nm, transpose(adjMtx))); 
} 
